<?php

$sockIn = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP)
	or die("Couldn't create listen socket");

include_once "config.inc.php";
include_once "load_insim.inc.php";
include_once "functions.inc.php";
include_once "class.inc.php";

if ($handle = opendir(PHPIS_PLUGINS))
{
    /* This is the correct way to loop over the directory. */
    while (false !== ($file = readdir($handle)))
        if (preg_match("~([a-z0-9_-]+)\\.plugin\\.php\$~i", $file, $match))
        {
        	include_once PHPIS_PLUGINS. "/". $file;
        	if (class_exists($match[1]))
        		$pluginName[] = $match[1];
        }

    closedir($handle);
}


// Try to bind one free port of a 1000 after the $listenPort number. The number $listenPort + $i will be sent to LFS.
for ($i = 0; $i < 1000; $i++)
	if (socket_bind($sockIn, $address, $listenPort + $i) === true)
		break;
if ($i == 1000)
	die('Could not bind to address'); 

$sockOut = socket_create(AF_INET, SOCK_DGRAM, SOL_UDP)
	or die("Couldn't create send socket");

socket_connect($sockOut, $address, $speakPort)
	or die('Could not connect to address'); 

$conn = new Connection($sockIn, $sockOut, $pluginName, true, true);

$conn->connect(array(
	"Type" => ISP_ISI,
	"ReqI" => 1,
	"UDPPort" => $listenPort + $i,
	"Flags" => 4 | 32,
	"Prefix" => ord($prefix),
	"Interval" => 50,
	"Admin" => "detail",
	"IName" => "detail"));

unset($i);

$arr = array(TINY_GTH, TINY_ISM, TINY_NCN, TINY_NPL, TINY_RES);

foreach($arr as $k => $v)
	$conn->sendPacket(compPacket(array("Type" => ISP_TINY, "SubT" => $v, "ReqI" => $k + 1)));

// The infinite loop
$timeStamp = 0;
while (true)
{
	$data = $conn->receivePacket();
	$conn->sendDelayed();
	
	// This flag is false if a text command was typed by a guest.
	$useCallback = true;
	
	// If the packet is MeSsageOut and the 7th byte is MSO_PREFIX, and there is a function registered for this command, then it will be called, and useCallback flag will be removed.
	if($data["Type"] == ISP_MSO)
	{
		print($data["UserType"]. " ". MSO_PREFIX. "\n");
		if ($data["UserType"] == MSO_PREFIX)
		{
			preg_match("~". preg_quote($prefix). "(\\S+)~", $data["Msg"], $match);
			$conn->callFunc("TXT_". $match[1], $data);
		}
	}
	
	// If no function for a text command was called, then try to find a function for this packet type.
	if ($useCallback === true)
	{

		/*
			Searching for the user function.
			We take the second and fourth bytes of the packet, then make a string like
			function_ISP_<second byte value>
			There must be defined a constant with this name in load_insim.inc.php
			In the constant there is a standard name for the packet. For example, for ISP_MSO
			the constant function_ISP_11 contanins the string "CBF_ISP_MSO"
			
			The trick is that when reading InSim structures from the pre-made file,
			I declare a constant X with the value int(1) and then
			a constant "func_1" with the value string("X").
			
			The sense of this manipulation is that the user calls the functions
			with a relatively readable text, like "..._MSO" rather than
			with a numeric "..._11".
		*/

		if ($data["Type"] == ISP_TINY)
			$conn->callFunc(constant("function_TINY_". $data["SubT"]), $data);
		elseif ($data["Type"] == ISP_SMALL)
			$conn->callFunc(constant("function_SMALL_". $data["SubT"]), $data);
		else
			$conn->callFunc(constant("function_ISP_". $data["Type"]), $data);
	
	}

	if (time() > $timeStamp)
	{
		print(date("Y-m-d H:i:s O"). " : time to send keepalive\n");

		$conn->sendPacket(compPacket(array("Type" => ISP_TINY, "SubT" => TINY_NONE)));
				
		$timeStamp = time() + 30;
		
		$f = fopen("db.log", "a");
		fwrite($f, date("\n\nY-m-d H:i:s\n"). print_r($conn->plugin["Livedb"], true));
		fclose($f);
		
		set_time_limit(70); // under Windows this setting didn't have any effect.
	}
}
